#Proyecto 5.2. Lugar para los corners

Partiendo de diferentes tableros vacíos con el cabezal en el origen, tenés que escribir 
un programa en el que se pueda obtener un tablero con _“semicírculos”_ rojos en las esquinas 
del borde Este, como se muestra en las figuras.

<center>
![Algunos tableros finales](data:image/png;base64,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)
</center>
                
Acordate que el desafío es construir **_un solo programa_**, pero ese programa tiene que 
funcionar **_en cualquier tablero inicial_** que se nos ocurra. 
El programa tiene que quedarte parecido al del proyecto anterior...

> **Probá, probá y probá**
>
> Asegurate de ejecutar el programa varias veces, con diferentes tableros iniciales y ver 
> que **_el mismo programa_** da siempre el resultado que esperás.

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/1.Descubrir%20Gobstones/5.2.Lugar%20para%20los%20corners/assets/resources/description.pdf "Enunciado de 'Lugar para los corners' en PDF"

